package demo.frame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import demo.common.*;
import demo.frame.FaceRecognition.GroupOperateDialog;
import demo.module.*;

import netsdk.callback.SUBSCRIBE_CALLBACK;
import netsdk.callback.impl.SUBSCRIBE_CALLBACK_IMPL;
import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;
import netsdk.lib.ErrorCodeAndConst;
import netsdk.lib.ToolKits;
import netsdk.struct.NET_DVR_IVE_VFD_RESULT_DATA_INFO_T;
import netsdk.struct.NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T;
import netsdk.struct.NET_DVR_IVE_VFD_RESULT_HEAD_T;
import netsdk.struct.NET_DVR_SUBSCRIBE_REPLY;
import netsdk.struct.NET_SDK_IVE_BASE_INFO;
import netsdk.struct.NET_SDK_IVE_FACE_MATCH_T;
import netsdk.struct.NET_SDK_IVE_PICTURE_INFO;
import unitTest.NET_SDK_A2IPC_Test.intelist;


class ThermalFrame extends JFrame{
	private boolean m_SubscribFaceDetect = false;
	public String m_serverAddressVFD;//
	public static SUBSCRIBE_CALLBACK FaceAlarmCB;
	private static final long serialVersionUID = 1L;
	
	private Vector<String> chnlist = new Vector<String>(); 
	private boolean isRealplay = false;
	private static boolean isAttach = false;
	// 预览句柄
	public static NativeLong m_hPlayHandle = new NativeLong(0);
	
	// 获取界面窗口
	private static JFrame frame = new JFrame();   
	
	public ThermalFrame() {
	    setTitle(Res.string().getRealplay());
	    setLayout(new BorderLayout());
	    pack();
	    setSize(800, 560);
	    setResizable(false);
	    setLocationRelativeTo(null);
		LoginModule.init();   // 打开工程，初始化
		
    	try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
        	e.printStackTrace();
        } 
	 
	    loginPanel = new LoginPanel();	    
	    add(loginPanel, BorderLayout.NORTH);
	    
	    thermalPanel = new ThermalPanel();
	    add(thermalPanel, BorderLayout.CENTER);

	
	  
		
	    
	    loginPanel.addLoginBtnActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {	   	    
				if(loginPanel.checkLoginText()) {
					if(login()) {
						frame = ToolKits.getFrame(e);
						frame.setTitle(Res.string().getThermalCamera() + " : " + Res.string().getOnline());
					}
				}
			}
		});
	    
	    loginPanel.addLogoutBtnActionListener(new ActionListener() {		
			@Override
			public void actionPerformed(ActionEvent e) {
				frame.setTitle(Res.string().getThermalCamera());
				logout();	
			}
		});
        
	    addWindowListener(new WindowAdapter() {
	    	public void windowClosing(WindowEvent e) {
	    		LoginModule.logout();
	    		LoginModule.cleanup();   // 关闭工程，释放资源
	    		dispose();	
	    		
	    		SwingUtilities.invokeLater(new Runnable() {
	    			public void run() {
	    				FunctionList demo = new FunctionList();
	    				demo.setVisible(true);
	    			}
	    		});
	    	}
	    });
	    FaceAlarmCB = new ThermalCallback();
        // TODO 设置智能分析事件上报回调
        DeviceSdk.INSTANCE.NET_SDK_SetSubscribCallBack(FaceAlarmCB, null);
	}
	public class ThermalCallback implements SUBSCRIBE_CALLBACK{

		@Override
		public void invoke(NativeLong lUserID, int dwCommand, Pointer pBuf, int dwBufLen, Pointer pUser) {
			System.out.println("智能报警回调方法被执行");
			switch (dwCommand) {
			case ErrorCodeAndConst.NET_SDK_N9000_ALARM_TYPE_VFD://人脸检测
				 /*NET_DVR_IVE_VFD_RESULT_HEAD_T+
	            [NET_DVR_IVE_VFD_RESULT_DATA_INFO_T+源数据]+
	            [NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T+人脸数据+人脸特征值]+...+
	            [NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T+人脸数据+人脸特征值*/
				
				int restLen = dwBufLen;
				NET_DVR_IVE_VFD_RESULT_HEAD_T head = new NET_DVR_IVE_VFD_RESULT_HEAD_T();
				int len = head.size();
				int offSetLen = 0;
				CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, head);
				head.read();
				offSetLen += len;//地址偏移
				restLen -= len;//剩余长度
				
				
				DateTimeFormatter format = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
				DateTime ctime = DateTime.parse(CommonFunctions.stampToDate(head.time), format); 
				String folerPath = CreatePath(lUserID.intValue(), ctime);
				
				NET_DVR_IVE_VFD_RESULT_DATA_INFO_T src = new NET_DVR_IVE_VFD_RESULT_DATA_INFO_T();
				len = src.size();			
				if (restLen < len){
					break;
				}
				CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, src);
				src.read();
				offSetLen += len;//地址偏移
				restLen -= len;//剩余长度
				if (restLen < src.dataLen){
					break;
				}
				if (src.dataLen > 0) {
					//原始背景图片
					byte[] data = pBuf.getByteArray(offSetLen, src.dataLen);
					File srcPic = new File(folerPath + "\\src.jpg");//
					try {
						srcPic.createNewFile();
						CommonFunctions.writeFileByBytes(folerPath + "\\src.jpg",data,false);//数据写入文件中
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					offSetLen += src.dataLen;//地址偏移
					restLen -= src.dataLen;//剩余长度				
				}
				
				NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T face = new NET_DVR_IVE_VFD_RESULT_FACE_DATA_INFO_T();
				len = face.size();	
				if (restLen < head.faceCnt * len){
					break;
				}
				for (int i = 0; i < head.faceCnt; i++) {
					CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen, face);
					face.read();
					offSetLen += len;//地址偏移
					restLen -= len;//剩余长度
					if(face.temperature > 0) {
						System.out.println("the temperature is:" + face.temperature / 100);
						System.out.println("size is :" + face.size());
					}
					
					if (face.stFaceImgData.dataLen > 0) {
						//人脸图片
						byte[] data = pBuf.getByteArray(offSetLen, face.stFaceImgData.dataLen);
						
						File facePic = new File(folerPath + "\\face" + i + ".jpg");//
						try {
							facePic.createNewFile();
							CommonFunctions.writeFileByBytes(folerPath + "\\face" + i + ".jpg", data, false);//数据写入文件中
						} catch (IOException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						offSetLen += face.stFaceImgData.dataLen;//地址偏移
						restLen -= face.stFaceImgData.dataLen;//剩余长度		
					}
				}						
				break;
			case ErrorCodeAndConst.NET_SDK_N9000_ALARM_TYPE_FACE_MATCH_FOR_IPC://人脸比对
				//pBuf为NET_SDK_IVE_BASE_INFO+NET_SDK_IVE_PICTURE_INFO+图片数据(实时)+NET_SDK_IVE_PICTURE_INFO+图片数据(相册)
		        /*	----------------------
		        |	NET_SDK_IVE_BASE_INFO	|
		        -------------------------
		        |	NET_SDK_IVE_PICTURE_INFO	|
		        -------------------------
		        |	byte[]图片数据(实时)长度：NET_SDK_IVE_PICTURE_INFO.iPicSize		|
		        -------------------------
		        |	NET_SDK_IVE_PICTURE_INFO	|
		        -------------------------
		        |	byte[]图片数据(相册)长度：NET_SDK_IVE_PICTURE_INFO.iPicSize		|
		        -------------------------
		        |	NET_SDK_IVE_PICTURE_INFO	|
		        -------------------------
		        |	byte[]原始背景图片数据(相册)长度：NET_SDK_IVE_PICTURE_INFO.iPicSize		|
		        -------------------------*/
				int restLen1 = dwBufLen;
				NET_SDK_IVE_BASE_INFO baseInfo = new  NET_SDK_IVE_BASE_INFO();
				int len1 = baseInfo.size();
				int offSetLen1 = 0;			 
				 //int aa = Long.SIZE / 8;
				CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen1, baseInfo);
				baseInfo.read();
				offSetLen1 += len1;//地址偏移
				restLen1 -= len1;//剩余长度
				
				//DateTimeFormatter format1 = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
				//DateTime ctime1 = DateTime.parse(CommonFunctions.stampToDate(baseInfo.i64SnapTime), format1); 
				//String folerPath1 = CreatePath(lUserID.intValue(), ctime1);
				System.out.println("温度: " + baseInfo.temperature / 100);
				
				
				NET_SDK_IVE_PICTURE_INFO pictureInfo = new NET_SDK_IVE_PICTURE_INFO();
				len1 = pictureInfo.size();
				if(restLen1 < len1) {
					break;
				}
				CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen1, pictureInfo);
				pictureInfo.read();
				offSetLen1 += len1;//地址偏移
				restLen1 -= len1;//剩余长度
				if(restLen1 < pictureInfo.iPicSize) {
					break;
				}			 			
				//CommonFunctions.GetPointerDataToStruct(pBuf, 556, pictureInfo);
				 
				if (pictureInfo.iPicSize > 0) {//实时抓拍图片
					//System.out.println("抓拍时间" + CommonFunctions.stampToDate(baseInfo.i64SnapTime));
					System.out.println("抓拍id: " + baseInfo.iSnapPicId);
					System.out.println("相似度: " + baseInfo.iSimilarity);
					
					//byte[] data = pBuf.getByteArray(baseInfo.size() + pictureInfo.size(), pictureInfo.iPicSize);//图片数据(实时抓拍到的)，想办法保存到本地或者显示
					System.out.println("相似度: " + baseInfo.iSimilarity);
					offSetLen1 += pictureInfo.iPicSize;//地址偏移
					restLen1 -= pictureInfo.iPicSize;//剩余长度
				}
				
				
				if(restLen1 < len1) {
					break;
				}
				pictureInfo = new NET_SDK_IVE_PICTURE_INFO();
				CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen1, pictureInfo);
				pictureInfo.read();
				offSetLen1 += len1;//地址偏移
				restLen1 -= len1;//剩余长度
				if(restLen1 < pictureInfo.iPicSize) {
					break;
				}			 						 
				if (pictureInfo.iPicSize > 0) {//相册图片				
					offSetLen1 += pictureInfo.iPicSize;//地址偏移
					restLen1 -= pictureInfo.iPicSize;//剩余长度
				}
				
				if(restLen1 < len1) {
					break;
				}
				pictureInfo = new NET_SDK_IVE_PICTURE_INFO();
				CommonFunctions.GetPointerDataToStruct(pBuf, offSetLen1, pictureInfo);
				pictureInfo.read();
				offSetLen1 += len1;//地址偏移
				restLen1 -= len1;//剩余长度
				if(restLen1 < pictureInfo.iPicSize) {
					break;
				}			 						 
				if (pictureInfo.iPicSize > 0) {//原始背景图片				
					offSetLen1 += pictureInfo.iPicSize;//地址偏移
					restLen1 -= pictureInfo.iPicSize;//剩余长度
				}
				 			
				break;
			}
			 
			 	        
		}

		private String CreatePath(int userId, DateTime dt)
	    {
	        String tempPath = "D:\\" + userId + "\\" + dt.getYear() + AddZero(dt.getMonthOfYear()) + AddZero(dt.getDayOfYear());
	        File filePath = new File(tempPath);//
	        if(!filePath.exists()) {
	        	filePath.mkdirs();
	        }                   
	        return tempPath;
	    }
		private String AddZero(int time)
	    {
	        int a = time;        
	        return a > 9 ? String.valueOf(a) : "0" + a;
	    }
	}	
	
	// 登录
	public boolean login() {
		if(LoginModule.login(loginPanel.ipTextArea.getText(), 
						Integer.parseInt(loginPanel.portTextArea.getText()), 
						loginPanel.nameTextArea.getText(), 
						new String(loginPanel.passwordTextArea.getPassword()))) {
	
			loginPanel.setButtonEnable(true);
						
			setEnable(true);
			for(int i = 1; i < LoginModule.m_stDeviceInfo.videoInputNum + 1; i++) {
				chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
				
			}
			// 登陆成功，将通道添加到控件
			chnComboBox.setModel(new DefaultComboBoxModel(chnlist));	
			
		} else {
			JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
			return false;
		}
		return true;
	}
	
	// 登出
	public void logout() {

		RealPlayModule.stopRealPlay(m_hPlayHandle);
		LoginModule.logout();

		loginPanel.setButtonEnable(false);
		setEnable(false);
		realplayWindowPanel.repaint();   	
		
		isRealplay = false;
		realplayBtn.setText(Res.string().getStartRealPlay());
				
		isAttach = false;
		
		//attachBtn.setText(Res.string().getAttach());
//		globalPicLabel.setText(Res.string().getGlobalPicture() + " ------ [" + Res.string().getEventType() + "]");

//		globalPicShowPanel.setOpaque(true); 
//		globalPicShowPanel.repaint();

//		thermalConfigPanel.setOpaque(true); 
//		thermalConfigPanel.repaint();
//	
//		candidatePicShowPanel.setOpaque(true); 
//		candidatePicShowPanel.repaint();

//        timeTextField.setText("");
//    	sexTextField.setText("");
//    	ageTextField.setText("");
//    	raceTextField.setText("");
//    	eyeTextField.setText("");
//    	mouthTextField.setText("");
//    	maskTextField.setText("");
//    	beardTextField.setText("");   	
//
//    	nameTextField.setText("");
//    	sexTextField2.setText("");
//    	birthdayTextField.setText("");
//    	idNoTextField.setText("");
//    	groupIdTextField.setText("");
//    	groupNameTextField.setText("");
//    	similaryTextField.setText("");
		
		for(int i = 0; i < LoginModule.m_stDeviceInfo.videoInputNum + 1; i++) {
			chnlist.clear();
		}
		
		chnComboBox.setModel(new DefaultComboBoxModel());	
		
//		groupId = 0;	
//		globalBufferedImage = null;
//		personBufferedImage = null;
//		candidateBufferedImage = null;	
		
	}
	private void setEnable(boolean bln) {
		
		chnComboBox.setEnabled(bln);
		streamComboBox.setEnabled(bln);
		realplayBtn.setEnabled(bln);
		subscribVfdBtn.setEnabled(bln);
		subscribVfdMatchBtn.setEnabled(bln);

	}
	/*
	 * 预览界面通道、码流设置  以及抓图面板
	 */
	private ThermalPanel thermalPanel;
	
	/*
	 * 登录
	 */
	private LoginPanel loginPanel;	
	// 人脸库界面
	private GroupOperateDialog groupOperateDialog = null;

	private JPanel operatePanel;;   // 通道、预览、订阅		

	
	private JLabel chnlabel;
	private JLabel streamLabel;
	private JComboBox streamComboBox;
	private JComboBox chnComboBox;
	private JButton realplayBtn;
	private JButton subscribVfdBtn;
    private JButton subscribVfdMatchBtn;
    //private JButton faceEventRecordBtn;
    private Panel realplayWindowPanel;
	private static PaintPanel globalPicShowPanel;
	private static PaintPanel thermalConfigPanel;
	private static PaintPanel candidatePicShowPanel;
    
	private static JLabel globalPicLabel;
	
    /*
     * 人脸信息
     */
	private static JTextField timeTextField;
	private static JTextField sexTextField;
	private static JTextField ageTextField;
	private static JTextField raceTextField;
	private static JTextField eyeTextField;
	private static JTextField mouthTextField;
	private static JTextField maskTextField;
	private static JTextField beardTextField;
	
	/*
	 * 候选人信息
	 */
	private static JTextField nameTextField;
	private static JTextField sexTextField2;
	private static JTextField birthdayTextField;
	private static JTextField idNoTextField;
	private static JTextField groupIdTextField;
	private static JTextField groupNameTextField;
	private static JTextField similaryTextField;
	/*
	 * 预览
	 */

    
	public class ThermalPanel extends JPanel{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		public ThermalPanel() {
			BorderEx.set(this, "", 2);
			setLayout(new BorderLayout());
			
			JPanel operatePanel = new JPanel();   // 通道、预览、订阅		
			JPanel panel = new JPanel();	

			add(operatePanel, BorderLayout.NORTH);
			add(panel, BorderLayout.CENTER);
			
			/*
			 * 操作面板：通道、预览、订阅按钮
			 */
			chnlabel = new JLabel(Res.string().getChannel());
			chnComboBox = new JComboBox(); 
			
			streamLabel = new JLabel(Res.string().getStreamType());
			String[] stream = {Res.string().getMasterStream(), Res.string().getSubStream(), Res.string().getThirdStream(),Res.string().getFourthStream()};
			streamComboBox = new JComboBox(stream);
			
			realplayBtn = new JButton(Res.string().getStartRealPlay());
			subscribVfdBtn = new JButton(Res.string().getSubscribeVfdAndThermal());	
			subscribVfdMatchBtn = new JButton(Res.string().getSubscribeVfdMatchAndThermal());
			//faceEventRecordBtn = new JButton("查找事件记录");
			
			operatePanel.setLayout(new FlowLayout());
			operatePanel.add(chnlabel);
			operatePanel.add(chnComboBox);
			operatePanel.add(streamLabel);
			operatePanel.add(streamComboBox);			
			operatePanel.add(realplayBtn);
			operatePanel.add(subscribVfdBtn);
			operatePanel.add(subscribVfdMatchBtn);
			//operatePanel.add(faceEventRecordBtn);
			
			Dimension dim = new Dimension();
			dim.width = 120;
			dim.height = 20;
			
			chnComboBox.setPreferredSize(new Dimension(80, 20));
			streamComboBox.setPreferredSize(new Dimension(80, 20));
			//attachBtn.setPreferredSize(dim);
			realplayBtn.setPreferredSize(dim);
			subscribVfdBtn.setPreferredSize(dim);
			subscribVfdMatchBtn.setPreferredSize(dim);
			
			chnComboBox.setEnabled(false);
			streamComboBox.setEnabled(false);
			realplayBtn.setEnabled(false);
			subscribVfdBtn.setEnabled(false);
			subscribVfdMatchBtn.setEnabled(false);
			//faceEventRecordBtn.setEnabled(false);
			
			/*
			 * 预览、图片面板
			 */
			JPanel realplayPanel = new JPanel();
			JPanel globalPicPanel = new JPanel();
			ThermalConfig configPanel = new ThermalConfig();
			 
			//JPanel candidatePanel = new JPanel();
			
			realplayPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
			globalPicPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
			//configPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
			//candidatePanel.setBorder(new EmptyBorder(0, 5, 5, 5));
			
			panel.setLayout(new GridLayout(2, 2));
			
			panel.add(realplayPanel);
			panel.add(globalPicPanel);
			panel.add(configPanel);
			//panel.add(candidatePanel);
			
			/*
			 * 预览面板
			 */
			JLabel realplayLabel = new JLabel(Res.string().getRealplay());
			realplayWindowPanel = new Panel();
			realplayWindowPanel.setBackground(Color.GRAY);
			realplayPanel.setLayout(new BorderLayout());
			realplayPanel.add(realplayLabel, BorderLayout.NORTH);
			realplayPanel.add(realplayWindowPanel, BorderLayout.CENTER);
	
			
			// 预览
			realplayBtn.addActionListener(new ActionListener() {				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					realplay();
				}
			});		
			
			/*
			 * 测温配置面板
			 */
			JLabel configLabel = new JLabel("Config");				
			configPanel.add(configLabel, BorderLayout.NORTH);
			
			
			subscribVfdBtn.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					
				}
			});

			
		}
		
		
		public void subscribVfd() {
			int chn = 0;//IPC通道一般为0
			NET_DVR_SUBSCRIBE_REPLY.ByReference sSmartSubscrib = new NET_DVR_SUBSCRIBE_REPLY.ByReference();
			
			int index = ErrorCodeAndConst.intelist_Vfd;
			
			if(((LoginModule.m_stDeviceInfo.function[0] & (1<<index)) >> index == 1) && (LoginModule.m_stDeviceInfo.deviceType ==  2)){
				if(!m_SubscribFaceDetect) {
					boolean ret = DeviceSdk.INSTANCE.NET_SDK_SmartSubscrib(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_DVR_SMART_VFD, chn, sSmartSubscrib);
					if(ret) {
						m_SubscribFaceDetect = true;
						m_serverAddressVFD = new String(sSmartSubscrib.serverAddress);
					}
				}
				else {
					byte[] sb = m_serverAddressVFD.getBytes();
					Pointer pNativeData = new Memory(sb.length); 
					pNativeData.write(0, sb, 0, sb.length);		
					IntByReference dwResult = new IntByReference();
					boolean ret = DeviceSdk.INSTANCE.NET_SDK_UnSmartSubscrib(LoginModule.m_hLoginHandle, ErrorCodeAndConst.NET_DVR_SMART_VFD, chn, pNativeData, dwResult);
					if(ret) {
						m_SubscribFaceDetect = false;
						System.out.println("取消订阅人脸侦测报警成功");
					}
					// 释放内存
					long peer = Pointer.nativeValue(pNativeData);
					Native.free(peer);// 手动释放内存
					Pointer.nativeValue(pNativeData, 0);
				}
			}
		}
		
		// 预览
		public void realplay() {
			if(!isRealplay) {
				m_hPlayHandle = RealPlayModule.startRealPlay(chnComboBox.getSelectedIndex(), 
					    		0,
					    		realplayWindowPanel);
				if(m_hPlayHandle.longValue() > 0) {
					realplayWindowPanel.repaint();
					isRealplay = true;
					chnComboBox.setEnabled(false);
					streamComboBox.setEnabled(false);
					realplayBtn.setText(Res.string().getStopRealPlay());
					
				} else {
					JOptionPane.showMessageDialog(null, ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
				}
			} else {
				
				RealPlayModule.stopRealPlay(m_hPlayHandle);
				realplayWindowPanel.repaint();
				isRealplay = false;
				chnComboBox.setEnabled(true);
				streamComboBox.setEnabled(true);
				realplayBtn.setText(Res.string().getStartRealPlay());	
			}	
		}
		// 订阅
		public void realLoadPicture() {
			if(!isAttach) {
				if(LoginModule.m_stDeviceInfo.deviceType == ErrorCodeAndConst.NET_SDK_NVR) {
					
					
				}
				
			} else {
				//FaceRecognitionModule.stopRealLoadPicture(m_hAttachHandle);
				isAttach = false;
				//attachBtn.setText(Res.string().getAttach());

				globalPicLabel.setText(Res.string().getGlobalPicture() + " ------ [" + Res.string().getEventType() + "]");	

				globalPicShowPanel.setOpaque(true); 
				globalPicShowPanel.repaint();

				thermalConfigPanel.setOpaque(true); 
				thermalConfigPanel.repaint();
			
				candidatePicShowPanel.setOpaque(true); 
				candidatePicShowPanel.repaint();

		        timeTextField.setText("");
		    	sexTextField.setText("");
		    	ageTextField.setText("");
		    	raceTextField.setText("");
		    	eyeTextField.setText("");
		    	mouthTextField.setText("");
		    	maskTextField.setText("");
		    	beardTextField.setText("");   	

		    	nameTextField.setText("");
		    	sexTextField2.setText("");
		    	birthdayTextField.setText("");
		    	idNoTextField.setText("");
		    	groupIdTextField.setText("");
		    	groupNameTextField.setText("");
		    	similaryTextField.setText("");
		    	
			}
		}
		
	}
	
	/**
	 * 写成静态主要是防止被回收
	 */
	private static class AnalyzerDataCB implements SUBSCRIBE_CALLBACK {  	
		private AnalyzerDataCB() {}
			
		private static class AnalyzerDataCBHolder {
			private static final AnalyzerDataCB instance = new AnalyzerDataCB();
		}
		
		public static AnalyzerDataCB getInstance() {
			return AnalyzerDataCBHolder.instance;
		}
		
		public void invoke(NativeLong lUserID, int dwCommand, Pointer pBuf, int dwBufLen, Pointer pUser) 
        {
            if (dwBufLen == 0 || pBuf == null) {
                return;
            }   
			
			switch(dwCommand)
            {
				case ErrorCodeAndConst.NET_SDK_N9000_ALARM_TYPE_FACE_MATCH:  ///< 人脸识别事件
				{	
					NET_SDK_IVE_FACE_MATCH_T msg = new NET_SDK_IVE_FACE_MATCH_T();

					// 耗时20ms左右
            		ToolKits.GetPointerData(pBuf, msg);  

             
     	            msg = null;
     	            System.gc();
                      
					break;
				} 

				default:
					break;
            }
                   
//			return 0;           
        }
		

	}
	

}

public class Thermal {
	public static void main(String[] args) {	
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				ThermalFrame demo = new ThermalFrame();	
				demo.setTitle(Res.string().getThermalCamera());
				
				demo.setVisible(true);
			}
		});		
	}
}
